﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Data;
using System.Net;
using System.IO;

namespace AHOBPR_Job_Runner
{
    public class JsonParserJob : LoggedJob
    {
        protected override String LogFileName { get { return "AHOBPR_Job_Runner.log"; } }
        public override string Id { get { return "JP"; } }

        public override void Run()
        {
            base.StartLog();
            LogMessageToFile("Starting AHOBPR Json Parser...");
            base.CheckDiskSpace();

            int totalRecords = 0;
            List<String> queueIds = GetJsonQueueItems();
            //Make individual web requests to parse JSON:
            foreach (String queueId in queueIds)
            {
                try
                {
                    WebRequest request = WebRequest.Create(System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + "/jsonparser/" + queueId);
                    LogMessageToFile("REST service url: " + System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + "/jsonparser/" + queueId);
                    request.Method = "GET";
                    request.ContentType = @"application/json; charset=utf-8";
                    String secretKey = System.Configuration.ConfigurationManager.AppSettings["secretKey"];
                    request.Headers.Add("Authorization", "Basic " + secretKey);

                    HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                    string jsonResponse = string.Empty;
                    using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                    {
                        jsonResponse = sr.ReadToEnd();
                        LogMessageToFile("Response from REST service: " + jsonResponse);
                    }

                    totalRecords++;
                }
                catch (Exception ex)
                {
                    LogMessageToFile("JSON PARSER: Exception in web request -- ");
                    LogErrorMessage(ex);
                }
            }

            // Now process the ****followup**** questionnaires
            LogMessageToFile("---- Starting Follow up ---- ");
            queueIds = GetJsonQueueFollowupItems();
            //Make individual web requests to parse JSON:
            foreach (String queueId in queueIds)
            {
                try
                {
                    WebRequest request = WebRequest.Create(System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + "/jsonparserfollowup/" + queueId);
                    LogMessageToFile("REST service url: " + System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + "/jsonparserfollowup/" + queueId);
                    request.Method = "GET";
                    request.ContentType = @"application/json; charset=utf-8";
                    String secretKey = System.Configuration.ConfigurationManager.AppSettings["secretKey"];
                    request.Headers.Add("Authorization", "Basic " + secretKey);

                    HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                    string jsonResponse = string.Empty;
                    using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                    {
                        jsonResponse = sr.ReadToEnd();
                        LogMessageToFile("Response from REST service for followup: " + jsonResponse);
                    }

                    totalRecords++;
                }
                catch (Exception ex)
                {
                    LogMessageToFile("JSON PARSER FOLLOWUP: Exception in web request -- ");
                    LogErrorMessage(ex);
                }
            }

            // Now process the ****QUEUE_BATCH**** 
            LogMessageToFile("---- Processing Queue Batch ---- ");
            queueIds = GetQueueBatchItems();
            //Make individual web requests to process Queue Batch:
            foreach (String queueId in queueIds)
            {
                try
                {
                    WebRequest request = WebRequest.Create(System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + "/processqueuebatch/" + queueId);
                    
                    int AhobprWebServiceTimeout;
                    bool result = int.TryParse(System.Configuration.ConfigurationManager.AppSettings["AhobprWebServiceTimeout"], out AhobprWebServiceTimeout);
                    if (result)
                    {
                        request.Timeout = AhobprWebServiceTimeout;
                    }
                    else
                    {
                        request.Timeout = 350000; // <-- Default Value just in case there is something wron with the WebConfig file value.
                    }
                    LogMessageToFile("REST service url: " + System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + "/processqueuebatch/" + queueId);
                    request.Method = "GET";
                    request.ContentType = @"application/json; charset=utf-8";
                    String secretKey = System.Configuration.ConfigurationManager.AppSettings["secretKey"];
                    request.Headers.Add("Authorization", "Basic " + secretKey);

                    HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                    string jsonResponse = string.Empty;
                    using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                    {
                        jsonResponse = sr.ReadToEnd();
                        LogMessageToFile("Response from REST service for queue batch: " + jsonResponse);
                    }

                    totalRecords++;
                }
                catch (Exception ex)
                {
                    LogMessageToFile("JSON PARSER QUEUE BATCH: Exception in web request -- ");
                    LogErrorMessage(ex);
                }
            }


            LogMessageToFile("Processed " + totalRecords + " records.");
            LogMessageToFile("AHOBPR Json Parser execution is completed.");

        }

        /// <summary>
        /// Get Json Queue Items from the stored procedure
        /// </summary>
        /// <returns></returns>
        private List<String> GetJsonQueueItems()
        {
            List<String> result = new List<string>();

            string sqlConnectionString = System.Configuration.ConfigurationManager.AppSettings["SQLServerConnectionString"];
            using (SqlConnection dbConnection = new SqlConnection(sqlConnectionString))
            {
                dbConnection.Open();
                SqlCommand sqlCmd = new SqlCommand("AHOBPR.SP_GetJsonQueue", dbConnection);
                try
                {
                    sqlCmd.CommandType = CommandType.StoredProcedure;
                    sqlCmd.CommandTimeout = 0;
                    SqlDataReader dataReader = sqlCmd.ExecuteReader();
                    while (dataReader.Read())
                    {
                        result.Add(dataReader["JSON_QUEUE_ID"].ToString());
                    }
                    dataReader.Close();
                    LogMessageToFile("SP_GetJsonQueue executed.");

                    dbConnection.Close();
                    LogMessageToFile("The SqlConnection is closed.");
                }
                catch (Exception e)
                {
                    LogErrorMessage(e);
                    dbConnection.Close();
                    LogMessageToFile("The SqlConnection is closed.");
                }
            }

            return result;
        }


        /// <summary>
        /// Get Json Queue Items from the stored procedure
        /// </summary>
        /// <returns></returns>
        private List<String> GetJsonQueueFollowupItems()
        {
            List<String> result = new List<string>();

            string sqlConnectionString = System.Configuration.ConfigurationManager.AppSettings["SQLServerConnectionString"];
            using (SqlConnection dbConnection = new SqlConnection(sqlConnectionString))
            {
                dbConnection.Open();
                SqlCommand sqlCmd = new SqlCommand("AHOBPR.SP_GetJsonQueueFollowup", dbConnection);
                try
                {
                    sqlCmd.CommandType = CommandType.StoredProcedure;
                    SqlDataReader dataReader = sqlCmd.ExecuteReader();
                    while (dataReader.Read())
                    {
                        result.Add(dataReader["JSON_QUEUE_FOLLOWUP_ID"].ToString());
                    }
                    dataReader.Close();

                    LogMessageToFile("SP_GetJsonQueue executed.");

                    dbConnection.Close();
                    LogMessageToFile("The SqlConnection is closed.");
                }
                catch (Exception e)
                {
                    LogErrorMessage(e);
                    dbConnection.Close();
                    LogMessageToFile("The SqlConnection is closed.");
                }
            }

            return result;
        }

        /// <summary>
        /// Get the Queue Batch IDs from the stored procedure
        /// </summary>
        /// <returns></returns>
        private List<String> GetQueueBatchItems()
        {
            List<String> result = new List<string>();

            string sqlConnectionString = System.Configuration.ConfigurationManager.AppSettings["SQLServerConnectionString"];
            using (SqlConnection dbConnection = new SqlConnection(sqlConnectionString))
            {
                dbConnection.Open();
                SqlCommand sqlCmd = new SqlCommand("AHOBPR.SP_GetQueueBatch", dbConnection);
                try
                {
                    sqlCmd.CommandType = CommandType.StoredProcedure;
                    SqlDataReader dataReader = sqlCmd.ExecuteReader();
                    while (dataReader.Read())
                    {
                        result.Add(dataReader["QUEUE_BATCH_ID"].ToString());
                    }
                    dataReader.Close();

                    LogMessageToFile("SP_GetQueueBatch executed.");

                    dbConnection.Close();
                    LogMessageToFile("The SqlConnection is closed.");
                }
                catch (Exception e)
                {
                    LogErrorMessage(e);
                    dbConnection.Close();
                    LogMessageToFile("The SqlConnection is closed.");
                }
            }

            return result;
        }
    }
}
